#!/bin/sh
#
# This is a very simple script that uses gcc to link in a given .s
# file to the i9 runtime library, and uses i9filt to help 
# decode error messages
#
# Use this like ./linki9.sh -o binary foo.s
#
# Override to force -m32 if autodetection fails
ABI_FLAG=
CPU=`uname -m`
if [ $CPU = x86_64 ]; then
    ABI_FLAG=-m32
fi

DIR=`dirname $0`
echo $ABI_FLAG
gcc $ABI_FLAG $* -L$DIR -li9 2>&1 | $DIR/i9filt
