package parse;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

import ast.*;
import cms.util.maybe.Maybe;
import exceptions.SyntaxError;

public class ParserImpl  {

    public Maybe<Expr> parse(Reader r) {
        Tokenizer t = new Tokenizer(r);
        try {
            Expr e = parseExpr(t);
            return Maybe.some(e);
        } catch (SyntaxError s) {
            s.printStackTrace();
            return Maybe.none();
        }
    }

    private Expr parseExpr(Tokenizer t) throws SyntaxError {
        switch(t.peek().getType()){
            case LPAREN:
                t.next();
                return parseList(t);
            default:
                return parseAtom(t);
        }
    }

    private SList parseList(Tokenizer t) throws SyntaxError {
        List<Node> children = new ArrayList<>();
        while (t.peek().getType() != TokenType.RPAREN) {
            if (t.peek().getType() == TokenType.EOF) throw new SyntaxError("Unclosed parentheses");
            children.add(parseExpr(t));
        }
        t.next();
        return new SList(children);
    }

    private Atom parseAtom(Tokenizer t) throws SyntaxError {
        switch (t.peek().getType()) {
            case QUOTE:
                t.next();
                Str s = new Str(t.next().toStringToken().getValue());
                t.next();
                return s;
            case NUM:
                return new Num(t.next().toNumToken().getValue());
            default:
                throw new SyntaxError("Invalid atom");
        }
    }


}
