package main;

import ast.Expr;
import cms.util.maybe.Maybe;
import parse.ParserImpl;

import java.io.FileNotFoundException;
import java.io.FileReader;

public class ParseApp {
    public static void main(String[] args) {
        String file = args[0];

        try {
            FileReader fileReader = new FileReader(file);
            ParserImpl parser = new ParserImpl();

            Maybe<Expr> expr = parser.parse(fileReader);
            assert(expr.isPresent());
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}
