/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class A4
implements ChangeListener {
    private JFrame jf = null;
    JPanel image;
    JPanel compImage;
    JLabel imageLabel;
    JLabel compImageLabel;
    JSlider RSlider = new JSlider(1, 0, 25500, 25500);
    JSlider GSlider = new JSlider(1, 0, 25500, 0);
    JSlider BSlider = new JSlider(1, 0, 25500, 0);
    JSlider HSlider = new JSlider(1, 0, 35999, 0);
    JSlider SSlider = new JSlider(1, 0, 100, 100);
    JSlider VSlider = new JSlider(1, 0, 100, 100);
    JSlider CSlider = new JSlider(1, 0, 100, 0);
    JSlider MSlider = new JSlider(1, 0, 100, 100);
    JSlider YSlider = new JSlider(1, 0, 100, 100);
    JSlider KSlider = new JSlider(1, 0, 100, 0);

    public static void main(String[] args) {
        A4 a4 = new A4();
    }

    public A4() {
        this.jf = new JFrame("Color");
        this.jf.setSize(600, 200);
        this.jf.setResizable(false);
        Color rgb = new Color(255, 0, 0);
        HSV hsv = A4Methods.RGBtoHSV(rgb);
        CMYK cmyk = A4Methods.RGBtoCMYK(rgb);
        this.image = new JPanel();
        this.image.setSize(200, 200);
        this.imageLabel = new JLabel("");
        this.imageLabel.setPreferredSize(new Dimension(200, 160));
        this.imageLabel.setVerticalAlignment(1);
        this.image.add(this.imageLabel);
        this.compImage = new JPanel();
        this.compImage.setSize(200, 200);
        this.compImageLabel = new JLabel("");
        this.compImageLabel.setPreferredSize(new Dimension(200, 160));
        this.compImageLabel.setVerticalAlignment(1);
        this.compImage.add(this.compImageLabel);
        Box sliders = new Box(0);
        this.fixSlider(sliders, this.RSlider, 'R');
        this.fixSlider(sliders, this.GSlider, 'G');
        this.fixSlider(sliders, this.BSlider, 'B');
        sliders.add(Box.createRigidArea(new Dimension(20, 0)));
        this.fixSlider(sliders, this.CSlider, 'C');
        this.fixSlider(sliders, this.MSlider, 'M');
        this.fixSlider(sliders, this.YSlider, 'Y');
        this.fixSlider(sliders, this.KSlider, 'K');
        sliders.add(Box.createRigidArea(new Dimension(20, 0)));
        this.fixSlider(sliders, this.HSlider, 'H');
        this.fixSlider(sliders, this.SSlider, 'S');
        this.fixSlider(sliders, this.VSlider, 'V');
        Box GUI = new Box(0);
        GUI.add(this.image);
        GUI.add(this.compImage);
        GUI.add(sliders);
        this.setSliders(rgb, hsv, cmyk);
        this.setColorPanels(rgb, hsv, cmyk);
        this.jf.getContentPane().add(GUI);
        this.jf.pack();
        this.jf.setVisible(true);
    }

    public void fixSlider(Box sliders, JSlider s, char c) {
        Box b = new Box(1);
        b.add(new JLabel("" + c));
        b.add(s);
        sliders.add(b);
        s.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent e) {
        CMYK cmyk;
        Color rgb;
        HSV hsv;
        this.RSlider.removeChangeListener(this);
        this.GSlider.removeChangeListener(this);
        this.BSlider.removeChangeListener(this);
        this.HSlider.removeChangeListener(this);
        this.SSlider.removeChangeListener(this);
        this.VSlider.removeChangeListener(this);
        this.CSlider.removeChangeListener(this);
        this.MSlider.removeChangeListener(this);
        this.YSlider.removeChangeListener(this);
        this.KSlider.removeChangeListener(this);
        JSlider source = (JSlider)e.getSource();
        if (source.equals(this.HSlider) || source.equals(this.SSlider) || source.equals(this.VSlider)) {
            double H = (double)this.HSlider.getValue() / 100.0;
            double S = (double)this.SSlider.getValue() / 100.0;
            double V = (double)this.VSlider.getValue() / 100.0;
            hsv = new HSV(H, S, V);
            rgb = A4Methods.HSVtoRGB(hsv);
            cmyk = A4Methods.RGBtoCMYK(rgb);
        } else if (source.equals(this.RSlider) || source.equals(this.GSlider) || source.equals(this.BSlider)) {
            int R = (int)Math.round((double)this.RSlider.getValue() / 100.0);
            int G = (int)Math.round((double)this.GSlider.getValue() / 100.0);
            int B = (int)Math.round((double)this.BSlider.getValue() / 100.0);
            rgb = new Color(R, G, B);
            hsv = A4Methods.RGBtoHSV(rgb);
            cmyk = A4Methods.RGBtoCMYK(rgb);
        } else if (source.equals(this.CSlider) || source.equals(this.MSlider) || source.equals(this.YSlider) || source.equals(this.KSlider)) {
            double C = (double)this.CSlider.getValue() / 100.0;
            double M = (double)this.MSlider.getValue() / 100.0;
            double Y = (double)this.YSlider.getValue() / 100.0;
            double K = (double)this.KSlider.getValue() / 100.0;
            cmyk = new CMYK(C, M, Y, K);
            rgb = A4Methods.CMYKtoRGB(cmyk);
            hsv = A4Methods.RGBtoHSV(rgb);
        } else {
            return;
        }
        this.setSliders(rgb, hsv, cmyk);
        this.setColorPanels(rgb, hsv, cmyk);
        this.RSlider.addChangeListener(this);
        this.GSlider.addChangeListener(this);
        this.BSlider.addChangeListener(this);
        this.HSlider.addChangeListener(this);
        this.SSlider.addChangeListener(this);
        this.VSlider.addChangeListener(this);
        this.CSlider.addChangeListener(this);
        this.MSlider.addChangeListener(this);
        this.YSlider.addChangeListener(this);
        this.KSlider.addChangeListener(this);
    }

    public void setSliders(Color rgb, HSV hsv, CMYK cmyk) {
        this.RSlider.setValue(rgb.getRed() * 100);
        this.GSlider.setValue(rgb.getGreen() * 100);
        this.BSlider.setValue(rgb.getBlue() * 100);
        this.HSlider.setValue((int)(hsv.h * 100.0));
        this.SSlider.setValue((int)(hsv.s * 100.0));
        this.VSlider.setValue((int)(hsv.v * 100.0));
        this.CSlider.setValue((int)(cmyk.c * 100.0));
        this.MSlider.setValue((int)(cmyk.m * 100.0));
        this.YSlider.setValue((int)(cmyk.y * 100.0));
        this.KSlider.setValue((int)(cmyk.k * 100.0));
    }

    public void setColorPanels(Color rgb, HSV hsv, CMYK cmyk) {
        this.image.setBackground(rgb);
        Color compRgb = A4Methods.complementRGB(rgb);
        this.compImage.setBackground(compRgb);
        this.imageLabel.setForeground(compRgb);
        this.imageLabel.setText("<html>Color<br>RGB: " + A4Methods.toString(rgb) + "<br>HSV: " + A4Methods.toString(hsv) + "<br>CMYK: " + A4Methods.toString(cmyk) + "<br><br>" + "RGB slider ranges: 0..255.<br>" + "H slider range: 0..360 degrees.<br>" + "Other slider ranges: 0..1." + "</html>");
        this.compImageLabel.setForeground(rgb);
        HSV compHsv = A4Methods.RGBtoHSV(compRgb);
        CMYK compCmyk = A4Methods.RGBtoCMYK(compRgb);
        this.compImageLabel.setText("<html>Complementary Color<br>RGB: " + A4Methods.toString(compRgb) + "<br>HSV: " + A4Methods.toString(compHsv) + "<br>CMYK: " + A4Methods.toString(compCmyk) + "</html>");
        this.jf.setTitle("Color RGB: " + A4Methods.toString(rgb));
    }
}

